# coding=utf-8

from sandbox import sdk2
from sandbox.projects.common.build.YaMake2 import YaMake2

from sandbox.projects.Travel.tasks.TravelBuildBase2 import TravelBuildBase2


class TravelYaMake2(TravelBuildBase2, YaMake2):
    class Parameters(YaMake2.Parameters):
        with sdk2.parameters.Group("Travel build") as params:
            component_name = sdk2.parameters.String("Building component name", required=False)
            commit_message = sdk2.parameters.String("Patch's commit message", required=False, multiline=True)
            committer = sdk2.parameters.String("Patch's committer", required=False)
            revision = sdk2.parameters.String("Patch's revision", required=False)
            deploy_environment = sdk2.parameters.String("Environment for auto deploy (unstable|stable|testing). Default is testing", required=False)
            travel_filtering_target = sdk2.parameters.String("Build is triggered only when this target deps are changed", required=False)
            commit_paths = sdk2.parameters.String("Paths affected by commit", required=False)

    class Context(YaMake2.Context):
        is_build_skipped = False

    def on_create(self):
        TravelBuildBase2.on_create(self)

    def on_enqueue(self):
        YaMake2.on_enqueue(self)
        TravelBuildBase2.on_enqueue(self)

    def on_execute(self):
        targets = YaMake2.get_targets(self)
        if TravelBuildBase2.should_execute(self, make_targets=targets):
            TravelBuildBase2.on_execute(self)
            YaMake2.on_execute(self)

    def on_success(self, prev_status):
        if TravelBuildBase2.was_executed(self):
            YaMake2.on_success(self, prev_status)
        TravelBuildBase2.on_success(self, prev_status)

    def on_failure(self, prev_status):
        if TravelBuildBase2.was_executed(self):
            YaMake2.on_failure(self, prev_status)
        TravelBuildBase2.on_failure(self, prev_status)

    def on_timeout(self, prev_status):
        if TravelBuildBase2.was_executed(self):
            YaMake2.on_timeout(self, prev_status)
        TravelBuildBase2.on_timeout(self, prev_status)

    def on_break(self, prev_status, status):
        if TravelBuildBase2.was_executed(self):
            YaMake2.on_break(self, prev_status, status)
        TravelBuildBase2.on_break(self, prev_status, status)

    def on_release(self, additional_parameters):
        additional_parameters = TravelBuildBase2.patch_release_parameters(self, additional_parameters)
        TravelBuildBase2.before_release(self, additional_parameters)
        YaMake2.on_release(self, additional_parameters)
        TravelBuildBase2.after_release(self, additional_parameters)
