# coding=utf-8

from sandbox.projects.Travel.tasks import TravelBuildBase
from sandbox.projects.common.build import YaPackage


class TravelYaPackage(TravelBuildBase.TravelBuildBase, YaPackage.YaPackage):
    type = 'TRAVEL_YA_PACKAGE'

    input_parameters = YaPackage.YaPackage.input_parameters + [
        TravelBuildBase.ComponentName,
        TravelBuildBase.CommitMessage,
        TravelBuildBase.Committer,
        TravelBuildBase.Revision,
        TravelBuildBase.DeployEnvironment,
        TravelBuildBase.TravelFilteringTarget,
        TravelBuildBase.CommitPaths,
    ]

    def on_create(self):
        TravelBuildBase.TravelBuildBase.on_create(self)

    def on_enqueue(self):
        YaPackage.YaPackage.on_enqueue(self)
        TravelBuildBase.TravelBuildBase.on_enqueue(self)

    def on_execute(self):
        packages = [x[0] for x in YaPackage.YaPackage.package_type_map(self)]
        if TravelBuildBase.TravelBuildBase.should_execute(self, package_targets=packages):
            TravelBuildBase.TravelBuildBase.on_execute(self)
            YaPackage.YaPackage.on_execute(self)

    def on_success(self):
        if TravelBuildBase.TravelBuildBase.was_executed(self):
            YaPackage.YaPackage.on_success(self)
        TravelBuildBase.TravelBuildBase.on_success(self)

    def on_failure(self):
        if TravelBuildBase.TravelBuildBase.was_executed(self):
            YaPackage.YaPackage.on_failure(self)
        TravelBuildBase.TravelBuildBase.on_failure(self)

    def on_timeout(self):
        if TravelBuildBase.TravelBuildBase.was_executed(self):
            YaPackage.YaPackage.on_timeout(self)
        TravelBuildBase.TravelBuildBase.on_timeout(self)

    def on_break(self):
        if TravelBuildBase.TravelBuildBase.was_executed(self):
            YaPackage.YaPackage.on_break(self)
        TravelBuildBase.TravelBuildBase.on_break(self)

    def on_release(self, additional_parameters):
        TravelBuildBase.TravelBuildBase.before_release(self, additional_parameters)
        YaPackage.YaPackage.on_release(self, additional_parameters)
        TravelBuildBase.TravelBuildBase.after_release(self, additional_parameters)
