from sandbox import sdk2
from sandbox.common.types.task import ReleaseStatus

resource_releasers = [
    'andre487', 'gekar', 'lipkin', 'dench',
    'MT', 'MT_PRODUCT', 'MT_API', 'ARCADIA', 'BUILD_TOOLS',
]


class UatraitsDataBundle(sdk2.Resource):
    auto_backup = True
    releasable = True
    released = ReleaseStatus.STABLE
    release_subscribers = resource_releasers
    ttl = 'inf'


class UatraitsLibraryPy2(sdk2.Resource):
    releasable = True
    releasers = resource_releasers

    auto_backup = True
    any_arch = False

    __default_attribute__ = sdk2.parameters.String


class UatraitsLibraryPy3(sdk2.Resource):
    releasable = True
    releasers = resource_releasers

    auto_backup = True
    any_arch = False

    __default_attribute__ = sdk2.parameters.String
