import tarfile
import logging
import simplejson as sj


import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters
from sandbox.projects import resource_types


class UnpackResourcesArchive(sdk_task.SandboxTask):

    type = "UNPACK_RESOURCES_ARCHIVE"

    class ArchiveResource(sdk_parameters.ResourceSelector):
        name = 'archive_resource'
        description = 'Resource id for archive of resources'
        resource_type = resource_types.OTHER_RESOURCE
        required = True

    input_parameters = [
        ArchiveResource
    ]

    def on_execute(self):
        archive_file = self.sync_resource(self.ctx[self.ArchiveResource.name])
        with tarfile.TarFile(archive_file, 'r') as arc:
            arc.extractall()

            with open('resources_description.json', 'r') as f:
                descr = sj.load(f)

            for resource_descr in descr:
                filename = resource_descr['filename']
                resource_type = resource_descr['type']
                attributes = resource_descr['attributes']

                logging.info("Trying to save file {} as resource of type {} with attributes: {}".format(
                    filename,
                    resource_type,
                    attributes
                ))

                self.create_resource(
                    "Some description",
                    filename,
                    resource_type,
                    owner=self.owner,
                    attributes=attributes
                )

        # Drop archive resource


__Task__ = UnpackResourcesArchive
