# -*- coding: utf-8 -*-

import logging
import sandbox.common.types.client as ctc
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters
from sandbox.sandboxsdk import environments


VAULT_USER = "MODADVERT"
YT_TOKEN_VAULT_NAME = "barney-yt-token"


class UpdateAbuseRemoderationTable(sdk_task.SandboxTask):
    type = "UPDATE_ABUSE_REMODERATION_TABLE"

    class YtProxyUrl(sdk_parameters.SandboxStringParameter):
        name = "yt_proxy_url"
        description = name

    class DstTable(sdk_parameters.SandboxStringParameter):
        name = "dst_table"
        description = name
        default_value = "//home/modadvert/AbuseRemoderationJoined"

    class RemoderationRequstsTable(sdk_parameters.SandboxStringParameter):
        name = "abuse_remoderation_requests_table"
        description = name
        default_value = "//home/modadvert/AbuseRemoderation"

    class ProdBannersTable(sdk_parameters.SandboxStringParameter):
        name = "prod_banners_table"
        description = name
        default_value = "//home/direct-moderate/prod-banners"

    class CheckRemoderationStatusUrl(sdk_parameters.SandboxStringParameter):
        name = "check_remoderation_status_url"
        description = name
        default_value = "http://intapi.direct-mod.yandex.ru:7080/jsonrpc/"

    input_parameters = [
        YtProxyUrl,
        DstTable,
        RemoderationRequstsTable,
        ProdBannersTable,
        CheckRemoderationStatusUrl
    ]

    environment = (
        environments.PipEnvironment("yandex-yt", "0.7.16-0"),
        environments.PipEnvironment("yandex-yt-yson-bindings-skynet")
    )

    client_tags = ctc.Tag.LINUX_PRECISE

    def on_execute(self):
        logging.info('starting UpdateAbuseRemoderationTable on_execute()...')
        from . import run_update
        from projects.common.modadvert.utils import yt_connect

        ytc = yt_connect(
            self.ctx.get(self.YtProxyUrl.name),
            self.get_vault_data(VAULT_USER, YT_TOKEN_VAULT_NAME),
            '/skynet/python/bin/python'
        )
        run_update.run_update(
            yt_client=ytc,
            dst_table=self.ctx.get(self.DstTable.name),
            prod_banners_table=self.ctx.get(self.ProdBannersTable.name),
            abuse_remoderation_requests_table=self.ctx.get(self.RemoderationRequstsTable.name),
            check_remoderation_status_url=self.ctx.get(self.CheckRemoderationStatusUrl.name)
        )

        logging.info('finished UpdateAbuseRemoderationTable on_execute()')


__Task__ = UpdateAbuseRemoderationTable
