# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.CalcBusinessRating import CalcBusinessRating as build_task

from sandbox.projects.common.geosearch.indexing import generate_base_update_task

BaseUpdate = generate_base_update_task(
    build_task=build_task,
    index_type_for_timestamp=resource_types.BUSINESS_COMPUTED_RATINGS,
    release_subject="Business computed ratings update"
)


class UpdateBusinessComputedRating(BaseUpdate):
    """
        Updates business computed rating
    """
    type = 'UPDATE_BUSINESS_COMPUTED_RATING'


__Task__ = UpdateBusinessComputedRating
