# -*- coding: utf-8 -*-
from sandbox.sandboxsdk.paths import copy_path

from sandbox.projects import resource_types
from sandbox.projects.common.geosearch.indexing import generate_single_url_updater

DEFAULT_SOURCES = {
    'stable': 'http://export.photo.yandex.net/sprav-org-photos.xml',
    'testing': 'http://export.photo.yandex.net/sprav-org-photos.xml',
}

BaseUpdater = generate_single_url_updater(index_type=resource_types.BUSINESS_PHOTOS,
                                          release_subject='Geosearch business photos update',
                                          default_sources=DEFAULT_SOURCES)


class UpdateBusinessPhotos(BaseUpdater):
    """
        Update business photos, just ask status and download
    """
    type = 'UPDATE_BUSINESS_PHOTOS'

    def create_index_from_data(self, resource_path):
        new_path = 'sprav-org-photos.xml'
        copy_path(resource_path, new_path)
        return new_path


__Task__ = UpdateBusinessPhotos
