import os

from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk import environments
from sandbox.projects.common.utils import get_or_default
from sandbox.projects import resource_types

TMPL = '{0}\t<?xml version="1.0" encoding="UTF-8" ?><Photos xmlns="http://maps.yandex.ru/snippets/photos/1.x" xmlns:atom="http://www.w3.org/2005/Atom"><count>{1}</count></Photos>\n'


class UpdateBusinessPhotosAltay(SandboxTask):
    """
        Update business photos, just ask status and download
    """
    type = 'UPDATE_BUSINESS_SNIPPET_PHOTOS'

    class InputTableParameter(SandboxStringParameter):
        description = 'Input table with objects from entity search'
        name = 'entity_table'
        default_value = '//home/sprav/altay/stats/permalinks_photo_cnt'

    class InputClusterParameter(SandboxStringParameter):
        description = 'YT cluster'
        name = 'cluster'
        default_value = 'hahn.yt.yandex.net'

    input_parameters = (
        InputClusterParameter,
        InputTableParameter,
    )
    environment = (environments.PipEnvironment('yandex-yt'), environments.PipEnvironment('saaspy'),)

    def on_execute(self):
        from yt.wrapper import YtClient

        yt_token = self.get_vault_data('mesherin', 'YQL_TOKEN')
        cluster = get_or_default(self.ctx, self.InputClusterParameter)
        table = get_or_default(self.ctx, self.InputTableParameter)
        client = YtClient(proxy=cluster, token=yt_token)

        os.environ['YT_TOKEN'] = yt_token
        out_fn = "./org-maps-export.txt"
        out_file = open(out_fn, 'w')

        for r in client.read_table(table, format='dsv', raw=False):
            out_file.write(TMPL.format(r['permalink'], r['number_of_photos']))

        self.create_resource('Photos export', out_fn, resource_types.BUSINESS_SNIPPET_PHOTOS)


__Task__ = UpdateBusinessPhotosAltay
