# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters


class Task(sdk_task.SandboxTask):
    """ A task, which obtain conveyors from https://fml.yandex-team.ru/kosher/conveyor/list and update conveyor dashboard redis cache. """

    class FMLTokenName(sdk_parameters.SandboxStringParameter):
        name = "fml_token"
        description = "Vault with fml Token"

    type = "UPDATE_CONVEYOR_DASHBOARD_CONVEYORS_CACHE"
    input_parameters = [FMLTokenName]

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import get_file
        import cacher_http_wrapper

        fml_token = self.get_vault_data(self.ctx[self.FMLTokenName.name])

        url = "https://fml.yandex-team.ru/kosher/conveyor/list"
        conveyors_list_raw = get_file.GetFile.GetJSONByUrllib2(url, ["Authorization: OAuth {0}".format(fml_token)])
        logging.info('[RAW FML ANSWER]\n' + str(conveyors_list_raw))
        conveyors_list = conveyors_list_raw['conveyors']
        logging.info(conveyors_list)
        candidates = {conv_id for conv_id in conveyors_list if conv_id >= 1394}

        url = "https://conveyor-dashboard-bl.n.yandex-team.ru/conveyors/get_list"
        conveyors_at_cache = set(get_file.GetFile.GetJSONByUrllib2(url, [])['data']['all_conveyors_list'])

        for conv_id in candidates.difference(conveyors_at_cache):
            logging.info(conv_id)
            url = "https://conveyor-dashboard-cacher.n.yandex-team.ru/cacher/full_conveyor_cache_init/{0}".format(conv_id)
            result = get_file.GetFile.GetJSONByUrllib2(url, [])
            logging.info(result)
            cacher_url = "https://conveyor-dashboard-cacher.n.yandex-team.ru"
            result = cacher_http_wrapper.init_ranking_models_cache(conv_id, cacher_url)
            logging.info(result)


__Task__ = Task
