# coding=utf-8

import sys
import logging
import json
import time
import itertools

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task


class Task(sdk_task.SandboxTask):
    """ A task, which obtain conveyors from https://fml.yandex-team.ru/kosher/conveyor/list and update conveyor dashboard redis cache. """

    type = "UPDATE_CONVEYOR_DASHBOARD_FORMULA_COMMIT_TREES_CACHE"
    input_parameters = []

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import get_file
        import cacher_http_wrapper
        import bl_http_wrapper
        import fml_helper_over_fmldb_orm

        json.encoder.c_make_encoder = None
        enc = json.JSONEncoder(separators=(', ', ': '), indent=2)

        def get_data_for_update(answer_to_update):
            data = {}
            for conv_id in itertools.chain(answer_to_update['to_rebuild'], answer_to_update['to_create']):
                before_hash = fml_helper_over_fmldb_orm.get_conveyor_status_md5(conv_id)
                ts = int(time.time())
                rms = cacher_http_wrapper.get_ranking_models_from_conveyor(conv_id, cacher_url)
                data[conv_id] = {}
                for rm in rms:
                    data[conv_id][rm] = {}
                    result = data[conv_id][rm]
                    rm_fc_tree = bl_http_wrapper.get_ranking_model_tree_time_limits(conv_id, rm, bl_url)
                    enc_json = enc.encode(rm_fc_tree)
                    result['json_report'] = enc_json
                    result['ts'] = ts
                    result['conveyor_status_hash'] = before_hash

            return data

        cacher_url = 'https://conveyor-dashboard-cacher.n.yandex-team.ru'
        bl_url = 'https://conveyor-dashboard-bl.n.yandex-team.ru'

        url = "/cacher/conveyors/refresh_formula_commit_cache/get_conv_to_refresh"
        answer = json.loads(
            get_file.GetFile.GetByUrllib2(
                cacher_url + url,
                ['Content-Type: application/json'],
                data=json.dumps({'bl_url': bl_url}),
                max_retry=5
            )
        )

        logging.info(answer)

        data = get_data_for_update(answer)

        for conv_id in data:
            for rm in data[conv_id]:

                url = "/cacher/conveyors/refresh_formula_commit_cache/set_cache/{0}/{1}".format(conv_id, rm)

                answer = json.loads(
                    get_file.GetFile.GetByUrllib2(
                        cacher_url + url,
                        ['Content-Type: application/json'],
                        data=json.dumps({
                            'json_report': data[conv_id][rm]['json_report'],
                            'ts': data[conv_id][rm]['ts'],
                            'conveyor_status_hash': data[conv_id][rm]['conveyor_status_hash']
                            }),
                        max_retry=5
                    ))
                logging.info(answer)


__Task__ = Task
