# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters


class Task(sdk_task.SandboxTask):
    """ A task, which obtain conveyors from https://conveyor-dashboard-cacher.n.yandex-team.ru/cacher/get_cached_conveyors and update NirvanaApi redis cache. """

    class NirvanaTokenName(sdk_parameters.SandboxStringParameter):
        name = "nirvana_token"
        description = "Vault with nirvana Token"

    class RedisCacheHostName(sdk_parameters.SandboxStringParameter):
        name = "redis_cache_host_name"
        description = "Redis cache host name"

    class RedisCachePortName(sdk_parameters.SandboxStringParameter):
        name = "redis_cache_port_name"
        description = "Redis cache port name"

    type = "UPDATE_CONVEYOR_DASHBOARD_NIRVANA_API_CACHE"
    input_parameters = [NirvanaTokenName, RedisCacheHostName, RedisCachePortName]

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import get_file
        import nirvana_api_redis_cache
        import nirvana_api

        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/contrib/python/redis"))

        import redis

        nirvana_token = self.get_vault_data(self.ctx[self.NirvanaTokenName.name])

        redis_cursor = redis.Redis(
            host=self.ctx[self.RedisCacheHostName.name],
            port=self.ctx[self.RedisCachePortName.name]
        )

        url = "https://conveyor-dashboard-cacher.n.yandex-team.ru/cacher/get_cached_conveyors"
        conveyors_list_raw = get_file.GetFile.GetJSONByUrllib2(url, ["Authorization: OAuth {0}".format(nirvana_token)])
        logging.info('[RAW FML ANSWER]\n' + str(conveyors_list_raw))
        conveyors_list = conveyors_list_raw['data']
        logging.info(conveyors_list)

        for conv_id in conveyors_list:
            logging.info(conv_id)
            url = "https://conveyor-dashboard-cacher.n.yandex-team.ru/fmldb/get_all_wfid_from_np_at_conveyor/{0}".format(conv_id)
            result = get_file.GetFile.GetJSONByUrllib2(url, [])

            wfids = result['wfids']
            logging.info(wfids)
            for wfid in wfids:
                if len(wfid) > 0:
                    url = "https://conveyor-dashboard-cacher.n.yandex-team.ru/cacher/is_wfid_cached/{0}".format(wfid)
                    raw_data = get_file.GetFile.GetJSONByUrllib2(url, [])
                    is_wfid_cached = raw_data['is_wfid_cached']
                    if is_wfid_cached:
                        logging.info('WFID {0} already at cache'.format(wfid))
                        n_api = nirvana_api.NirvanaAPI(wfid, nirvana_token)
                        nirvana_api_redis_cache.repair_and_refresh_nirvana_api_cache_helper(redis_cursor, n_api)
                        logging.info('Refreshing complete.')
                    else:
                        n_api = nirvana_api.NirvanaAPI(wfid, nirvana_token)
                        cache_dict = nirvana_api_redis_cache.naive_get_data_for_wfid_nirvana_api_cache(n_api)
                        nirvana_api_redis_cache.make_nirvana_api_cache(cache_dict, n_api, redis_cursor)
                        logging.info('Nirvana api for WFID {0} is cached'.format(wfid))


__Task__ = Task
