# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters


class Task(sdk_task.SandboxTask):
    """ A task, which obtain conveyors from https://conveyor-dashboard-cacher.n.yandex-team.ru/cacher/get_cached_conveyors and update NirvanaApi redis cache. """

    class RedisCacheHostName(sdk_parameters.SandboxStringParameter):
        name = "redis_cache_host_name"
        description = "Redis cache host name"

    class RedisCachePortName(sdk_parameters.SandboxStringParameter):
        name = "redis_cache_port_name"
        description = "Redis cache port name"

    type = "UPDATE_CONVEYOR_DASHBOARD_OUTPUT_FORMULA_CACHE"
    input_parameters = [RedisCacheHostName, RedisCachePortName]

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import get_file
        import nirvana_api_redis_cache
        import cacher_http_wrapper
        import nirvana_api_result_wrappers

        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/contrib/python/redis"))

        import redis

        redis_cursor = redis.Redis(
            host=self.ctx[self.RedisCacheHostName.name],
            port=self.ctx[self.RedisCachePortName.name]
        )

        cacher_url = 'https://conveyor-dashboard-cacher.n.yandex-team.ru'
        # logging.info(conveyors_list)

        for conv_id in cacher_http_wrapper.gen_cached_conveyors(cacher_url):
            # # Теперь непосредственно извлечение данных
            wfid_2_cache = {}
            for wfid in cacher_http_wrapper.fmldb_get_all_wfid_from_np_at_conveyor(conv_id, cacher_url):
                if len(wfid) > 0:
                    if cacher_http_wrapper.is_wfid_cached(wfid, cacher_url):
                        # print wfid, 'is cached'
                        _, cache = nirvana_api_redis_cache.check_cache_nirvana_api_for_wifd(redis_cursor, wfid)
                        wfid_2_cache[wfid] = cache

                        # es_json = wfid_2_cache[wfid]['es']['data']
                        # es = nirvana_api_result_wrappers.GetExecutionState(es_json)

                        wf_json = wfid_2_cache[wfid]['wf']['data']
                        wf = nirvana_api_result_wrappers.GetWorkflow(wf_json)

                        br_json = wfid_2_cache[wfid]['br']['data']
                        br = nirvana_api_result_wrappers.GetBlockResults(br_json)

                        for code in br.results_by_code:
                            br_at_code = br.results_by_code[code]
                            if 'outputFormula' in br_at_code.results_by_endpoint:
                                op_id = wf.operation_blocks_by_code[code].operationId
                                if op_id in nirvana_api_redis_cache.KNOWN_TRAINING_OPS:
                                    br_e_output_formula = br_at_code.results_by_endpoint['outputFormula']
                                    storage_path = br_e_output_formula.storagePath
                                    if storage_path is None:
                                        logging.info(wfid)
                                        logging.info(code)
                                        logging.info('There is no storage_path for outputFormula endpoint')
                                        continue
                                    elif nirvana_api_redis_cache.is_storage_path_hanging(redis_cursor, storage_path):
                                        logging.info('Storage path marked as hanging')
                                        continue

                                    key = nirvana_api_redis_cache.make_output_formula_key(storage_path)
                                    if not redis_cursor.exists(key):
                                        output_formula_json = get_file.GetFile.GetJSONByUrllib2(storage_path, [])
                                        logging.info(wfid)
                                        logging.info(code)
                                        logging.info(output_formula_json)
                                        if output_formula_json is None:
                                            logging.info('does not exist at Nirvana Storage')
                                            nirvana_api_redis_cache.register_hanging_nirvana_storage_path(redis_cursor, storage_path)
                                            continue

                                        nirvana_api_redis_cache.add_to_cache_output_formula(redis_cursor, storage_path, output_formula_json, op_id, code)
                                    else:
                                        logging.info('Already at cache')
                                else:
                                    logging.info("Operation {0} with result outputFormula is not recognized as Train Formula".format(op_id))

                    else:
                        logging.info("{0} is not cached ".format(wfid))


__Task__ = Task
