# -*- coding: utf-8 -*-

import sandbox.common.types.misc as ctm

from sandbox.projects import resource_types
from sandbox.projects.BuildMapsDatabaseAdvert import BuildMapsDatabaseAdvert as build_task


from sandbox.projects.common.geosearch.indexing import generate_base_update_task

BaseUpdate = generate_base_update_task(build_task=build_task,
                                       index_type_for_timestamp=resource_types.MAPS_DATABASE_ADVERT,
                                       release_subject="ADDRS Advert index update",
                                       inherit_notifications=True)


class UpdateMapsDatabaseAdvert(BaseUpdate):
    """
        Update maps database advert: ask ads.xml status, download, build index and publish it if required.
    """
    type = 'UPDATE_MAPS_DATABASE_ADVERT'
    dns = ctm.DnsType.DNS64
    cores = 1


__Task__ = UpdateMapsDatabaseAdvert
