# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.geosearch.indexing import generate_base_update_task
from sandbox.projects.BuildMapsDatabasePoi import BuildMapsDatabasePoi as build_task

BaseUpdate = generate_base_update_task(
    build_task=build_task,
    index_type_for_timestamp=resource_types.MAPS_DATABASE_POI,
    release_subject="ADDRS poi main index update",
    indexing_execution_space=140 * 1024
)


class UpdateMapsDatabasePoi(BaseUpdate):
    """
        Update maps database poi
    """
    type = 'UPDATE_MAPS_DATABASE_POI'


__Task__ = UpdateMapsDatabasePoi
