# -*- coding: utf-8 -*-

import os
import sys

from sandbox.sandboxsdk.parameters import SandboxSelectParameter
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.process import run_process
# from sandbox.sandboxsdk.environments import PipEnvironment

from sandbox.projects.common.gencfg import utils as config_generator_utils
from sandbox.projects.common.gencfg.task import IGencfgTask


class SubutilParameter(SandboxSelectParameter):
    name = 'subutil_name'
    description = 'Type of statistics to update'
    choices = [('Update unused hosts', 'update_unused_hosts'), ('Update groups usage', 'update_groups_usage')]


class GeneratorGitTagParameter(SandboxStringParameter):
    name = 'tag'
    description = 'Git tag'
    default_value = 'master'


class UpdateMongoStatistics(IGencfgTask):
    """
        Обновить аггрегированную статистику, собираемую heartbeat.instacneusage. Таск должен запускаться периодически.
        Статистика дальше используется для построения графиков в backend-е генерилки.
    """

    type = 'UPDATE_MONGO_STATISTICS'

    input_parameters = [SubutilParameter, GeneratorGitTagParameter]

    # environment = (
    #    PipEnvironment('pymongo', '3.0.3'),
    # )

    def get_generator_path(self):
        return self.abs_path('generator')

    def on_enqueue(self):
        pass

    def on_execute(self):
        config_generator_utils.clone_gencfg_all(self.get_generator_path(), 'full', tag=self.ctx[GeneratorGitTagParameter.name])

        run_process(["bash", "./install.sh", "tests"], work_dir=self.get_generator_path(), log_prefix="install")

        if self.ctx[SubutilParameter.name] == 'update_unused_hosts':
            run_process([sys.executable, os.path.join(self.get_generator_path(),
                        'utils', 'mongo', 'update_unused_duration.py'), '-s', 'ALL'],
                        log_prefix='update_unused_hosts')
        elif self.ctx[SubutilParameter.name] == 'update_groups_usage':
            run_process([sys.executable, os.path.join(self.get_generator_path(),
                        'utils', 'mongo', 'update_aggregate_usage.py'), '-g', 'ALL', '-l', '7200'],
                        log_prefix='update_groups_usage')
        else:
            raise Exception("Unknown subutil %s" % self.ctx[SubutilParameter.name])


__Task__ = UpdateMongoStatistics
