from sandbox.projects.MediaLib.media_zk import MediaZkClient
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects import DeployNannyDashboard

RELEASE_TYPE = 'prestable'


class DashboardName(SandboxStringParameter):
    name = 'dashboard'
    description = 'Dashboard name'
    default_value = 'images_newdb'
    required = True


class NannyDashboardDeployRecipe(SandboxStringParameter):
    name = 'dashboard_recipe_name'
    description = 'Dashboard recipe name'
    default_value = 'deploy_images_newdb'
    required = True


class ShardmapTaskToDeploy(SandboxStringParameter):
    name = 'shardmap_task'
    description = 'Shardmap generator task type'
    required = True


class ShardmapTaskId(SandboxStringParameter):
    name = 'shardmap_task_id'
    description = 'Shardmap generator task id'
    required = True


class ZkFlagPath(SandboxStringParameter):
    name = 'zk_flag_path'
    description = 'Zookeeper flag'
    default_value = '/media-services/images/flags/newdb/newdb_uploaded'
    required = True


class ShardmapFilename(SandboxStringParameter):
    name = 'shardmap_filename'
    description = 'Zookeeper flag data'
    required = True


class UploadImagesDatabase(SandboxTask):
    type = 'UPLOAD_IMAGES_DATABASE'
    execution_space = 128
    input_parameters = [DashboardName, NannyDashboardDeployRecipe, ShardmapTaskToDeploy, ShardmapTaskId, ZkFlagPath, ShardmapFilename]

    def initCtx(self):
        self.ctx['kill_timeout'] = 24 * 60 * 60  # 24 hours

    def on_execute(self):
        if not self.list_subtasks():
            deploy_task_params = {
                'deployment_task_id': self.ctx[ShardmapTaskId.name],
                'deployment_release_status': RELEASE_TYPE,
                'deployment_nanny_dashboard_name': self.ctx[DashboardName.name],
                'deployment_nanny_dashboard_recipe': self.ctx[NannyDashboardDeployRecipe.name],
                'deployment_nanny_bool_wait': True
            }

            self.create_subtask(
                task_type=DeployNannyDashboard.DeployNannyDashboard.type,
                description='Upload images database',
                input_parameters=deploy_task_params
            )

            self.wait_all_tasks_completed(self.list_subtasks())

        with MediaZkClient() as zk:
            if not zk.exists(self.ctx[ZkFlagPath.name]):
                zk.create(self.ctx[ZkFlagPath.name], makepath=True)
            zk.set(self.ctx[ZkFlagPath.name], value=str("{}".format(self.ctx[ShardmapFilename.name])))


__Task__ = UploadImagesDatabase
