# -*- coding: utf-8 -*-

from sandbox.projects.MediaLib.UploadMediaDatabase import UploadMediaDatabase, NewDBDashboardName, NewDBDashboardRecipe, ZkFlagPath, ServicesFromRecipe


NEWDB_DASHBOARD_NAME = 'images_newdb'
NEWDB_DEPLOY_RECIPE = 'deploy_images_newdb'
ZK_FLAG_PATH = '/media-services/images/flags/newdb/newdb_uploaded'
SERVICES_FROM_RECIPE = True


class UploadImagesDatabaseNG(UploadMediaDatabase):
    """Приезд большой базы Картинок"""

    type = 'UPLOAD_IMAGES_DATABASE_NG'
    switch_type = 'images'

    # Monitoring settings
    monitoring_sleep = 10 * 60  # 10 min
    monitoring_time = 18 * 60 * 60  # 18 hours
    monitoring_telegram_chat_id = '-1001088652476'
    monitoring_email_to = 'images-newdb@yandex-team.ru'
    monitoring_vault_name = 'telegram_token'
    monitoring_vault_owner = 'IMAGES-BASE-DEPLOY'

    def initCtx(self):
        UploadMediaDatabase.initCtx(self)

        # override inputs
        self.ctx[NewDBDashboardName.name] = NEWDB_DASHBOARD_NAME
        self.ctx[NewDBDashboardRecipe.name] = NEWDB_DEPLOY_RECIPE
        self.ctx[ZkFlagPath.name] = ZK_FLAG_PATH
        self.ctx[ServicesFromRecipe.name] = SERVICES_FROM_RECIPE


__Task__ = UploadImagesDatabaseNG
