# -*- coding: utf-8 -*-

from sandbox.projects.MediaLib.UploadMediaDatabase import UploadMediaDatabase, NewDBDashboardName, NewDBDashboardRecipe, ZkFlagPath


NEWDB_DASHBOARD_NAME = 'video_newdb'
NEWDB_DEPLOY_RECIPE = 'deploy_video_newdb'
ZK_FLAG_PATH = '/media-services/video/flags/newdb_video_sbase/on_production'


class UploadVideoDatabaseNG(UploadMediaDatabase):
    """Приезд большой базы Видео"""

    type = 'UPLOAD_VIDEO_DATABASE_NG'
    switch_type = 'video'

    # Monitoring settings
    monitoring_sleep = 10 * 60  # 10 min
    monitoring_time = 8 * 60 * 60  # 8 hours
    monitoring_telegram_chat_id = '-1001117977095'
    monitoring_email_to = 'video-newdb@yandex-team.ru'
    monitoring_vault_name = 'video-warden-bot-token'
    monitoring_vault_owner = 'VIDEO-ROBOT'

    def initCtx(self):
        UploadMediaDatabase.initCtx(self)

        # override inputs
        self.ctx[NewDBDashboardName.name] = NEWDB_DASHBOARD_NAME
        self.ctx[NewDBDashboardRecipe.name] = NEWDB_DEPLOY_RECIPE
        self.ctx[ZkFlagPath.name] = ZK_FLAG_PATH


__Task__ = UploadVideoDatabaseNG
