# -*- coding: utf-8 -*-

from urlparse import urlsplit, urlunsplit
from url_tools import get_queries_from_urls

import yt.wrapper as yt


def relative(url):
    abs_parts = urlsplit(url)
    relative_parts = ('', '') + abs_parts[2:]
    return urlunsplit(relative_parts)


def for_each_result_row(table_path, counter_fn, urls_fn):
    # yt.read_table грузит чанками по необходимости
    for row in yt.read_table(table_path):
        counter = unicode(row['counter'], 'utf-8')

        if counter_fn is not None:
            counter_fn(counter)

        for key, value in row.iteritems():
            if key == 'counter':
                continue

            platform = key
            urls = value

            if urls_fn is not None:
                queries = get_queries_from_urls(urls)
                absolute_urls = map(lambda url: unicode(url, 'utf-8'), urls)
                relative_urls = map(lambda url: unicode(relative(url), 'utf-8'), urls)

                urls_fn(counter, platform, absolute_urls, relative_urls, queries)
