# -*- coding: utf-8 -*-

from urlparse import urlparse, urlunparse


AMP = '&'
EQ = '='


def normalize_url(url, exclude_params=None):
    """
    Нормализуем урлы:
    — выкидываем повторяющиеся параметры с одинаковыми значениями (a=1&a=1 => a=1)
    — сортируем параметры по алфавиту (включая значения b=a&a=b&a=a => a=a&a=b&b=a)
    — не трогаем параметры с пустым значением (a=1&b= => a=1&b=)
    — выкидываем параметры если они в списке exclude_params
    — не трогаем случаи exp_flags=a=1,a=1,b=1,b=1
    """

    parsed = urlparse(url)

    if not parsed.query:
        return url

    params = parsed.query.split(AMP)
    params = set(params)

    if exclude_params:
        for param in params.copy():
            if param.split(EQ)[0] in exclude_params:
                params.remove(param)

    params = sorted(params)
    parsed = parsed._replace(query=AMP.join(params))

    return urlunparse(parsed)
