# -*- coding: utf-8 -*-

import io
import json

from for_each_result_row import for_each_result_row


def prepare_json(
        output_table_path,
        absolute_file_path,
        relative_file_path,
        queries_file_path,
):
    # формат таблицы неудобен для работы из js
    # данные с абсолютными урлами
    result_absolute = {}
    # данные с относительными урлами вместо абсолютных, старый формат
    result_relative = {}
    # данные с поисковыми запросами вместо ссылок
    result_queries = {}

    def handle_counter(counter):
        result_absolute[counter] = {}
        result_relative[counter] = {}
        result_queries[counter] = {}

    def handle_urls(counter, platform, absolute_urls, relative_urls, queries):
        result_absolute[counter][platform] = absolute_urls
        result_relative[counter][platform] = relative_urls
        result_queries[counter][platform] = queries

    for_each_result_row(output_table_path, handle_counter, handle_urls)

    def save_json(file_path, data):
        with io.open(file_path, 'w', encoding='utf8') as f:
            json_str = json.dumps(data, ensure_ascii=False)
            f.write(json_str)

    save_json(absolute_file_path, result_absolute)
    save_json(relative_file_path, result_relative)
    save_json(queries_file_path, result_queries)
