# -*- coding: utf-8 -*-

import json

import plyvel

from for_each_result_row import for_each_result_row


def prepare_leveldb(
        output_table_path,
        absolute_db_path,
        relative_db_path,
        queries_db_path,
):
    absolute_db = plyvel.DB(absolute_db_path, create_if_missing=True)
    relative_db = plyvel.DB(relative_db_path, create_if_missing=True)
    queries_db = plyvel.DB(queries_db_path, create_if_missing=True)

    absolute_wb = absolute_db.write_batch()
    relative_wb = relative_db.write_batch()
    queries_wb = queries_db.write_batch()

    # should be compatible with nodejs `encoding-down` module
    def jsonify(elem):
        return json.dumps(elem, separators=(',', ':'))

    def handle_urls(counter, platform, absolute_urls, relative_urls, queries):
        key = [counter, platform]

        absolute_wb.put(jsonify(key), jsonify(absolute_urls))
        relative_wb.put(jsonify(key), jsonify(relative_urls))
        queries_wb.put(jsonify(key), jsonify(queries))

    for_each_result_row(output_table_path, None, handle_urls)

    absolute_wb.write()
    relative_wb.write()
    queries_wb.write()

    absolute_db.close()
    relative_db.close()
    queries_db.close()
