# -*- coding: utf-8 -*-

import yt.wrapper as yt
from yt.wrapper.ypath import ypath_split
import datetime

TTL_IN_DAYS = 7


def _extract_isodate_from_table(table):
    return ypath_split(table)[-1].split('_')[0]


def stale_tables(base_path):
    tables = yt.list(base_path, absolute=True)

    delta = datetime.timedelta(days=TTL_IN_DAYS)
    min_date = (datetime.date.today() - delta).isoformat()
    is_stale = lambda t: _extract_isodate_from_table(t) <= min_date

    return filter(is_stale, tables)


def remove_stale_tables(base_path):
    for t in stale_tables(base_path):
        yt.remove(t)
