# -*- coding: utf-8 -*-

from normalize_url import normalize_url

EXCLUDE_PARAMS = {
    'clid',
    'callback',
    'yu',
    'retpath',
    'rnd',
    'ncrnd',
    'rdrnd',
    'yandexuid'
}


def uniq_urls(urls, exclude=EXCLUDE_PARAMS):
    normalized_urls = set()
    result = set()

    for url in urls:
        normalized = normalize_url(url, exclude)

        if normalized not in normalized_urls:
            normalized_urls.add(normalized)
            result.add(url)

    return result
