# -*- coding: utf-8 -*-

from urlparse import urlparse, parse_qs


def get_queries_from_urls(urls):
    queries = map(get_query_from_url, urls)

    return filter(bool, queries)


def get_query_from_url(url):
    parsed_url = urlparse(url)
    query = parse_qs(parsed_url.query).get('text')

    # В query всегда лежит последовательность utf8 байтов
    try:
        if not query:
            return None

        # Если строка сразу с типом 'unicode' возвращаем её
        if isinstance(query[0], unicode):
            return query[0]

        # Если строка с типом 'str' пытаемся раскодировать её как utf8
        return query[0].decode('utf8')
    except:
        # Если последовательность байтов не удалось декодировать из utf8 то игнорируем
        return None

    return None
