# -*- coding: utf-8 -*-

from sandbox import sdk2


class URLS_BY_SHOW_COUNTERS_EXECUTABLE(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


class URLS_BY_SHOW_COUNTERS_DATA(sdk2.Resource):
    """See FEI-7133 ticket."""

    auto_backup = True
    any_arch = True
    ttl = 'inf'
    # format is deprecated, remove it after clients migrate to new attr
    format = sdk2.parameters.String
    data_format = sdk2.parameters.String
    max_urls = sdk2.parameters.Integer
    tlds_coverage = sdk2.parameters.Bool


class ABSOLUTE_URLS_BY_SHOW_COUNTERS_DATA(sdk2.Resource):
    """See FEI-8060 ticket."""

    auto_backup = True
    any_arch = True
    ttl = 'inf'
    # format is deprecated, remove it after clients migrate to new attr
    format = sdk2.parameters.String
    data_format = sdk2.parameters.String
    max_urls = sdk2.parameters.Integer
    tlds_coverage = sdk2.parameters.Bool


class URLS_BY_SHOW_COUNTERS_DEBUG_DATA(sdk2.Resource):
    """See FEI-7492 ticket."""

    auto_backup = False
    any_arch = True
    ttl = 1
    # format is deprecated, remove it after clients migrate to new attr
    format = sdk2.parameters.String
    data_format = sdk2.parameters.String
    max_urls = sdk2.parameters.Integer
    tlds_coverage = sdk2.parameters.Bool


class QUERIES_BY_SHOW_COUNTERS(sdk2.Resource):
    """See FEI-12759 ticket."""

    auto_backup = False
    any_arch = True
    ttl = 3
    # format is deprecated, remove it after clients migrate to new attr
    format = sdk2.parameters.String
    data_format = sdk2.parameters.String
    max_urls = sdk2.parameters.Integer
    tlds_coverage = sdk2.parameters.Bool
