from sandbox import sdk2
from sandbox.projects.VerticalsAdmin.exec_script import VerticalsAdminExecScript
from sandbox.projects.sandbox.resources import LXC_CONTAINER
import sandbox.common.types.misc as ctm
import sandbox.common.types.client as ctc


class VerticalsAdminExecDocker(VerticalsAdminExecScript):
    """
    Exec shell script in given container
    """

    class Requirements(VerticalsAdminExecScript.Requirements):
        disk_space = 100 * 1024
        # Required for containers with docker, because most docker-registries are ipv4 only
        dns = ctm.DnsType.DNS64
        # need for cleanup volumes (docker chache) in task dir ?WHY?
        privileged = False
        cores = 8
        ram = 8192
        # platform = "linux_ubuntu_12.04_precise"

        class Caches(VerticalsAdminExecScript.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(VerticalsAdminExecScript.Parameters):
        container = sdk2.parameters.Container(
            "LXC Container resource to use",
            resource_type=LXC_CONTAINER,
            required=True,
            # default='34'  # !! only for local sandbox
            # default='856640615'  # uncomment in real sandbox linux_ubuntu_18.04_bionic
            default='773239891'  # uncomment in real sandbox linux_ubuntu_16.04_xenial
        )
        kill_timeout = 86400  # 12h

    def on_save(self):
        super(VerticalsAdminExecScript, self).on_save()
