from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.projects.VerticalsAdmin.exec_script.ExecScriptBase import ExecScriptBase


class VerticalsAdminExecScript(ExecScriptBase):
    class Requirements(ExecScriptBase.Requirements):
        pass

    class Parameters(ExecScriptBase.Parameters):
        fail_fast = sdk2.parameters.Bool('Fail on first error', default=True)

    class Context(sdk2.Task.Context):
        fail_fast = True
        exceptions = False

    def on_exception(self, e):
        if self.Context.fail_fast:
            raise e
        else:
            self.set_info('Delay exception %s' % str(e))
            self.Context.exceptions = True

    def get_workspace(self):
        return super(VerticalsAdminExecScript, self).get_workspace()

    def do_execute(self):
        ExecScriptBase.Context.out_resource_list = []

        # Fail fast if out_resource_list is not well formed
        self.Context.fail_fast = self.Parameters.fail_fast
        ExecScriptBase.on_execute(self)

    def on_execute(self):
        self.do_execute()
        if self.Context.exceptions:
            raise TaskFailure('FORCE_FAILURE: Delayed exceptions found, see logs above')
