import os
import sys
import shutil

OUTPUT_FOLDER = "/tmp/mygit"
WORKFLOWS_FOLDER = ".github/workflows"


def repo_has_actions(repo_folder):
    return os.path.isdir(os.path.join(repo_folder, WORKFLOWS_FOLDER))


def main():
    if len(sys.argv) < 2:
        return 0
    output_folder = OUTPUT_FOLDER
    if len(sys.argv) == 3:
        output_folder = sys.argv[1]
    folder = sys.argv[2]
    repo_name = folder.split('/')[-1]
    if repo_has_actions(folder):
        src = os.path.join(folder, WORKFLOWS_FOLDER)
        dst = os.path.join(output_folder, repo_name)
        shutil.copytree(src, dst)
    return 0


if __name__ == "__main__":
    main()
