# -*- coding: utf-8 -*-
import logging
import os
from sandbox import sdk2
from sandbox.projects.stop_leak.base_hector_task.hector_git import BaseHectorGitTask
from sandbox.projects.stop_leak.resource_types import HectorResults
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.stop_leak.common import sectools


class VertisYadiAnalyzer(BaseHectorGitTask):
    vcs_type = 'gh'
    vcs = 'github'
    hector_command = 'gh'
    use_ssh = True
    privileged = True
    # hardcoded
    gh_url = "https://api.github.com/"
    results_path = ''

    class Parameters(BaseHectorGitTask.Parameters):
        repository_name = sdk2.parameters.String('Repository name', default='YandexClassifieds/search-tree')
        projects_name = sdk2.parameters.String('Project name', default='YandexClassifieds')
        github_url = sdk2.parameters.String('Github base url', default='https://api.github.com/')
        vcs_type = 'gh'

    def _hector_env(self):
        env = super(VertisYadiAnalyzer, self)._hector_env()
        env['GH_TOKEN'] = sdk2.Vault.data(self.owner, 'STOP_LEAK_GITHUB_TOKEN')
        return env

    def _prepare_env(self):
        super(VertisYadiAnalyzer, self)._prepare_env()

    def _hector_command(self):
        hector_cmd, yadi_cmd = super(VertisYadiAnalyzer, self)._hector_command()
        hector_cmd.remove('--parse-stdout')
        hector_cmd.append('--projects=' + self.Parameters.projects_name)
        hector_cmd.append('--gh-url=' + self.Parameters.github_url)
        hector_cmd.append('--private-only')
        self.yadi_path = sectools.download('yadi', 'latest')
        yadi_cmd = [
            '--',
            self.yadi_path,
            'test',
            '-r',
            '-f',
            'json'
        ]
        logging.info("Running cmd = %s", " ".join(hector_cmd) + " ".join(yadi_cmd))
        if self.Parameters.vcs_type in ['gh', 'bb']:
            self.hector_command = self.Parameters.vcs_type

        return hector_cmd, yadi_cmd

    def _save_to_res(self):
        results_archive_path = str(self.path('results.tar.gz'))
        if os.path.isdir(self.results_path) is False or os.listdir(self.results_path) == []:
            return
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('create results archive')) as pl:
            sp.check_call('cd {path} && tar cvzf {tgz} *'.format(path=self.results_path, tgz=results_archive_path),
                          shell=True, stderr=pl.stdout, stdout=pl.stdout)

        logging.info(results_archive_path)
        try:
            logging.info('Prepare to ResourceData')
            sdk2.ResourceData(
                HectorResults(
                    self,
                    'Hector %s results' % self.vcs,
                    results_archive_path,
                    results_type=self.vcs
                )
            )
            logging.info('Success')
        except Exception as e:
            logging.info('Error:')
            logging.info(e)

    def on_execute(self):
        self._prepare_env()
        self.hector_path = sectools.download('hector', self.Parameters.hector_version)
        self.results_path = str(self.path('results'))
        os.mkdir(self.results_path)
        logging.info('results path: ' + self.results_path)

        if self.ramdrive:
            self.work_path = str(self.ramdrive.path / 'work')
        else:
            self.work_path = str(self.path('work'))
        os.mkdir(self.work_path)
        logging.info('working path: ' + self.work_path)

        self.state_in_path = None
        if self.Parameters.load_state:
            self.state_in_path = self._load_state()

        self.state_out_path = None
        if self.Parameters.save_state:
            self.state_out_path = self._save_state_path()

        hector_cmd, ant_secret_cmd = self._hector_command()
        cmd = hector_cmd + ant_secret_cmd
        logging.info('Results cmd =' + ' '.join(cmd))
        if self.use_ssh:
            with sdk2.ssh.Key(self, self.owner, 'STOP_LEAK_SSH_KEY'):
                logging.info('cmd = ', cmd)
                self._run_hector(cmd)
        else:
            self._run_hector(cmd)
        logging.info('saving resources')
        self._save_to_res()
