# -*- coding: utf-8 -*-

import os.path

import sandbox.common.types.misc as ctm

from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.parameters import SandboxArcadiaUrlParameter
from sandbox.sandboxsdk.environments import VirtualEnvironment


class BetaUrl(SandboxStringParameter):
    name = 'beta_url'
    description = 'Beta'


class ProdUrl(SandboxStringParameter):
    name = 'prod_url'
    description = 'Production'
    default_value = 'test'


class VerticalsTestsSvnUrlParameter(SandboxStringParameter):
    name = 'verticals_tests_svn_url'
    description = 'Verticals tests svn url'
    default_value = SandboxArcadiaUrlParameter.default_value + '/search/garden/runtime_tests'


class TestsDataPathParameter(SandboxStringParameter):
    name = 'tests_data_path'
    description = 'Tests data path (relative to tests root).'
    default_value = 'ylitedata/TestData/kubr'


class VerticalsTestWrapper2Simplified(SandboxTask):
    type = 'VERTICALS_TEST_WRAPPER_2_SIMPLIFIED'
    dns = ctm.DnsType.DNS64

    input_parameters = [BetaUrl, ProdUrl, VerticalsTestsSvnUrlParameter, TestsDataPathParameter]

    def get_tests(self):
        tests_path = self.abs_path('runtime_tests')
        tests_arcadia_url = self.ctx[VerticalsTestsSvnUrlParameter.name]
        Arcadia.export(tests_arcadia_url, tests_path)
        return tests_path

    def on_execute(self):
        beta_url = self.ctx['beta_url']
        prod_url = self.ctx['prod_url']
        tests_root = self.get_tests()
        tests_path = os.path.join(tests_root, 'ylitedata')
        tests_data_path = os.path.join(tests_root, self.ctx['tests_data_path'])

        with VirtualEnvironment(use_system=True) as venv:
            venv.pip('pip')
            venv.pip('pytest-rerunfailures')
            venv.pip('pytest-xdist')
            venv.pip('runtime.queries')
            proc = run_process(
                [
                    'py.test',
                    '-n', "8",
                    '-v',
                    '-rs',
                    '--reruns=2',
                    '--prod', prod_url,
                    '--beta', beta_url,
                    '--test-data-path', tests_data_path,
                    tests_path,
                ],
                log_prefix='run_test',
                check=False,
                work_dir=tests_path
            )

        if proc.returncode != 0:
            raise SandboxTaskFailureError("Tests Failed!")


__Task__ = VerticalsTestWrapper2Simplified
