# -*- coding: utf-8 -*-

from sandbox.projects import resource_types

from sandbox.projects import VideoBuildAndTestDynamicModels
from sandbox.projects import VideoBuildMiddleDynamicModels
from sandbox.projects import VideoTestDynamicModelsArchive


class VideoBuildAndTestMiddleDynamicModels(VideoBuildAndTestDynamicModels.VideoBuildAndTestDynamicModels):
    """
        Таск сначала собирает архив с моделями
        из указанного источника, а затем
        тестирует полученный архив.

        Для сборки применяется таск VIDEO_BUILD_MIDDLE_DYNAMIC_MODELS
        Для тестирования применяется таск VIDEO_TEST_DYNAMIC_MODULES_ARCHIVE
    """

    type = 'VIDEO_BUILD_AND_TEST_MIDDLE_DYNAMIC_MODELS'

    archive_type = resource_types.VIDEO_MIDDLE_DYNAMIC_MODELS_ARCHIVE

    build_task_type = 'VIDEO_BUILD_MIDDLE_DYNAMIC_MODELS'

    test_task_type = 'VIDEO_TEST_MIDDLE_DYNAMIC_MODELS_ARCHIVE'

    input_parameters = VideoBuildMiddleDynamicModels.VideoBuildMiddleDynamicModels.input_parameters + (
        VideoTestDynamicModelsArchive.UseCustomVideosearchParameter,
        VideoTestDynamicModelsArchive.VideosearchParameter
    )


__Task__ = VideoBuildAndTestMiddleDynamicModels
