from sandbox.projects import resource_types
from playercollector import PlayerCollector
import sandbox.sandboxsdk as sdk
import tempfile
import os


class VideoBuildConnectorsRaw(sdk.task.SandboxTask):
    type = "VIDEO_BUILD_CONNECTORS_RAW"
    environment = (
        sdk.environments.PipEnvironment("yandex-yt"),
        sdk.environments.PipEnvironment("yandex-yt-yson-bindings-skynet")
    )

    def on_execute(self):
        import yt.wrapper as yt

        raw_players_table = "//home/videoindex/players/raw.db"
        html5_players_table = "//home/videoindex/players/html5.db"

        ytc = yt.YtClient(proxy="arnold.yt.yandex.net", token=self.get_vault_data("VIDEODEV", "yt_token"))

        player_collector = PlayerCollector(ytc)
        player_collector.add_players(raw_players_table, "__raw_")
        player_collector.add_players(html5_players_table, "__html5_")

        connectors_xml = player_collector.create_connectors_xml()

        temp_path = os.path.join(tempfile.mkdtemp(), "connectors_raw.xml")
        with open(temp_path, "w") as f:
            f.write(connectors_xml)

        resource_id = self.create_resource(
            "video autoplayer config", 'config',
            resource_types.VIDEO_CONFIG_AUTOPLAYER,
        ).id
        resource = sdk.channel.channel.sandbox.get_resource(resource_id)
        sdk.paths.copy_path(temp_path, resource.path)
        sdk.channel.channel.task.mark_resource_ready(resource)
