# -*- coding: utf-8 -*-

from sandbox.projects import BuildDynamicModels
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common.dynamic_models.compare import generate_diff_footer
from sandbox.projects.common.nanny import nanny

from sandbox.projects import resource_types
from sandbox.sandboxsdk.parameters import SandboxSvnUrlParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter


class ModelsUrlForProduction(SandboxSvnUrlParameter):
    """
        SVN URL для продакшн формул
    """
    name = 'models_svn_url_production'
    description = 'production models svn url (get latest released if empty)'
    default_value = media_settings.VideoSettings.DYNAMIC_MODELS_SVN_PRODUCTION_TRUNK_URL
    required = False


class ModelsUrlForExperiment(SandboxSvnUrlParameter):
    """
        SVN URL для экспериментальных формул
    """
    name = 'models_svn_url_experiment'
    description = 'experiment models svn url (get latest if empty)'
    default_value = media_settings.VideoSettings.DYNAMIC_MODELS_SVN_EXPERIMENT_TRUNK_URL
    required = False


class CheckProductionModelsList(SandboxBoolParameter):
    name = 'check_production_models_list'
    description = 'Check that production models contain Hast, Wizard and fast models'
    default_value = False


class StrictFormulaIdChecks(SandboxBoolParameter):
    name = 'strict_check_formula_id'
    description = 'Checks that all formulas contain ID and throws exception if true.'
    default_value = False


class FailWithoutSlices(SandboxBoolParameter):
    name = 'fail_without_slices'
    description = 'fail if formula without slices'
    default_value = False


class Deduplicate(SandboxBoolParameter):
    name = 'deduplicate_formulas'
    description = 'Turn on file-wise deduplication'
    default_value = False


class VideoBuildDynamicModels(BuildDynamicModels.BuildDynamicModels, nanny.ReleaseToNannyTask):
    """
        Таск выкачивает модели из SVN по указанному URL
        и собирает их в архив с помощью tools/archiver.

        Использует таск BuildDynamicModels как основу.
    """

    type = 'VIDEO_BUILD_DYNAMIC_MODELS'

    description = 'Dynamic models archive for videosearch'

    archive_name = 'videosearch_models.archive'

    resourse_type = resource_types.VIDEO_DYNAMIC_MODELS_ARCHIVE

    input_parameters = (
        BuildDynamicModels.ModelsForProduction,
        ModelsUrlForProduction,
        BuildDynamicModels.ModelsForExperiment,
        ModelsUrlForExperiment,
        CheckProductionModelsList,
        StrictFormulaIdChecks,
        FailWithoutSlices,
        Deduplicate,
        BuildDynamicModels.ModelsUrls,
        BuildDynamicModels.CheckSize,
        BuildDynamicModels.MaxArchiveSize,
    )

    def get_resource_type(self):
        return 'VIDEO_DYNAMIC_MODELS_ARCHIVE'

    def filter_models(self, files):
        return files

    @property
    def footer(self):
        return generate_diff_footer(self.ctx.get('diff'))


__Task__ = VideoBuildDynamicModels
