# -*- coding: utf-8 -*-

import urllib

from sandbox.projects import resource_types
from sandbox.projects.common.search.settings import VideoSettings

from sandbox.projects.common.pumpkin import serp_task
from sandbox.projects.common.mediasearch import yasm_task

from sandbox.sandboxsdk import parameters


_PUMPKIN_CGI_PARAMS = "promo=pumpkin&exp_flags=video_desktop_serp_porno_tiles=0&exp_flags=video_desktop_serp_tiles=0&no-tests=1&noredirect=1&numdoc=5"
_NOTFOUND_CGI_PARAMS = "{0}&site=fake".format(_PUMPKIN_CGI_PARAMS)
_EXECUTED_KEY = "_task_executed"

_PLATFORM_DESKTOP = "desktop"
_PLATFORM_TOUCH = "touch"


class PlatformParameter(parameters.SandboxStringParameter):
    name = 'platform'
    description = 'Platform'
    choices = [(_PLATFORM_DESKTOP, _PLATFORM_DESKTOP), (_PLATFORM_TOUCH, _PLATFORM_TOUCH)]
    default_value = _PLATFORM_DESKTOP
    required = True


class VideoBuildPumpkinSerp(yasm_task.YasmTask, serp_task.BaseBuildPumpkinSerpTask):
    type = "VIDEO_BUILD_PUMPKIN_SERP"

    INDEX_RESOURCE_TYPE = resource_types.VIDEO_PUMPKIN_INDEX
    ARCHIVE_RESOURCE_TYPE = resource_types.VIDEO_PUMPKIN_INDEX_ARCHIVE

    input_parameters = (PlatformParameter,) + serp_task.BaseBuildPumpkinSerpTask.input_parameters

    def on_execute(self):
        # yasm_notify can raise TemporaryError, so we need to avoid a double work
        if _EXECUTED_KEY not in self.ctx:
            serp_task.BaseBuildPumpkinSerpTask.on_execute(self)
            self.ctx[_EXECUTED_KEY] = 1

        domain = self.ctx[serp_task.DomainParameter.name]
        self._yasm_notify(push_signal_name="video_build_pumpkin_serp_{}".format(domain))

    def _make_production_attributes(self, domain):
        return VideoSettings.pumpkin_resource_attributes(domain)

    def _make_serp_url(self, domain, text):
        return "{0}/search?text={1}&{2}".format(self._make_url(domain), urllib.quote(text), _PUMPKIN_CGI_PARAMS)

    def _make_main_page_url(self, domain):
        return "{0}?{1}".format(self._make_url(domain), _PUMPKIN_CGI_PARAMS)

    def _make_notfound_page_url(self, domain):
        return "{0}/search?{1}".format(self._make_url(domain), _NOTFOUND_CGI_PARAMS)

    def _make_url(self, domain):
        url = serp_task.BaseBuildPumpkinSerpTask._make_url(self, domain)
        if url is not None:
            return url

        if domain == serp_task.RU_DOMAIN:
            return "https://yandex.ru/video"
        else:
            return "https://yandex.com.tr/video"

        if self.ctx[PlatformParameter.name] == _PLATFORM_TOUCH:
            url += "/touch"

    def _make_test_task(self, urls_resource_id, serps_resource_id):
        from projects.VideoTestPumpkinSerp import VideoTestPumpkinSerp
        from projects.VideoTestPumpkinSerp import UrlsResourceParameter
        from projects.VideoTestPumpkinSerp import SerpsResourceParameter

        sub_ctx = {
            UrlsResourceParameter.name: urls_resource_id,
            SerpsResourceParameter.name: serps_resource_id
        }
        sub_task = self.create_subtask(
            task_type=VideoTestPumpkinSerp.type,
            input_parameters=sub_ctx,
            description=self.descr,
            execution_space=self.execution_space
        )
        return sub_task.id


__Task__ = VideoBuildPumpkinSerp
