from sandbox.projects import resource_types
from rkn_config_builder import RknConfigBuilder
from sandbox import sandboxsdk as sdk
import tempfile
import os


class VideoBuildConnectorsRaw(sdk.task.SandboxTask):
    type = "VIDEO_BUILD_RKN_BAN"
    environment = (
        sdk.environments.PipEnvironment("yandex-yt"),
        sdk.environments.PipEnvironment("yandex-yt-yson-bindings-skynet")
    )

    def on_execute(self):
        import yt.wrapper as yt

        ytc = yt.YtClient(proxy="banach.yt.yandex.net", token=self.get_vault_data("robot-video-acc", "yt_token"))
        rkn_builder = RknConfigBuilder(ytc)
        rkn_ban = rkn_builder.create_config()

        temp_path = os.path.join(tempfile.mkdtemp(), "rkn_ban.json")
        with open(temp_path, "w") as f:
            f.write(rkn_ban)

        resource_id = self.create_resource(
            "video rkn ban config", 'config',
            resource_types.VIDEO_RKN_BAN,
        ).id
        resource = sdk.channel.channel.sandbox.get_resource(resource_id)
        sdk.paths.copy_path(temp_path, resource.path)
        sdk.channel.channel.task.mark_resource_ready(resource)
