import json

player_node = "Players"
host_node = "Hosts"


class RknRow():
    def __init__(self, row):
        self.host = row["Host"]
        self.player_id = row["PlayerId"]


class RknConfigBuilder():
    def __init__(self, ytc, src_table_path="//home/videoindex/players/rkn_ban"):
        self.src_table = ytc.select_rows("Host, PlayerId FROM [{0}]".format(src_table_path))
        self.players = set()
        self.hosts = set()

        self.extract_data()

    def extract_data(self):
        for row in self.src_table:
            data = RknRow(row)
            player_id = data.player_id
            host = data.host

            if player_id != "":
                self.players.add(player_id)

            if host != "":
                self.hosts.add(host)

    def create_config(self):
        result_dict = {
            player_node: list(self.players),
            host_node: list(self.hosts)
        }

        return json.dumps(result_dict)
