# -*- coding: utf-8 -*-_read_resource

import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.copy as sdk_copy
import sandbox.sandboxsdk.environments as sdk_environments

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types

from unban_creator import UnbanCreator
import json

filename = "unban.json"
src_path = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/player/unban.json"
unban_ids_node = "unban_player_ids"


class VideoBuildUnbanRaw(sdk_task.SandboxTask):
    type = 'VIDEO_BUILD_UNBAN_RAW'
    environment = (
        sdk_environments.PipEnvironment("yandex-yt"),
        sdk_environments.PipEnvironment("yandex-yt-yson-bindings-skynet")
    )

    def on_execute(self):
        resource_id = self.create_resource(
            "video Vegas config", 'config',
            resource_types.VIDEO_CONFIG_UNBAN,
        ).id
        resource = channel.sandbox.get_resource(resource_id)
        dst_path = resource.path

        self.get_unban_config(src_path, dst_path)
        self.add_raw_unban_config(dst_path)

        channel.task.mark_resource_ready(resource)

    def on_release(self, additional_parameters):
        sdk_task.SandboxTask.on_release(self, additional_parameters)

    def get_unban_config(self, src, dst):
        sdk_copy.RemoteCopy(src, dst,
                                   log_dir=self.log_path())(timeout=sdk_copy.RemoteCopy.DEFAULT_TIMEOUT)

    def add_raw_unban_config(self, file):
        import yt.wrapper as yt

        raw_players_table = "//home/videoindex/players/raw.db"
        html5_players_table = "//home/videoindex/players/html5.db"

        ytc = yt.YtClient(proxy="arnold.yt.yandex.net", token=self.get_vault_data("VIDEODEV", "yt_token"))
        unban_cr = UnbanCreator(ytc)
        unban_cr.add_players(raw_players_table, "__raw_")
        unban_cr.add_players(html5_players_table, "__html5_")
        raw_config = unban_cr.get_unban_config()

        fs = open(file, 'r')
        config = json.load(fs)
        fs.close()

        for player_id in raw_config[unban_ids_node]:
            config[unban_ids_node][player_id] = raw_config[unban_ids_node][player_id]

        ws = open(file, 'w')
        json.dump(config, ws, indent=4)
        ws.close()


__Task__ = VideoBuildUnbanRaw
