from collections import defaultdict

host_col = "Host"
source_col = "PlayerSource"
type_col = "PlayerType"
result_col = "Result"
time_col = "Timestamp"
created_time_col = "CreatedTimestamp"
platform_col = "Platform"

platform_node = "platforms"
host_node = "hosts"
with_node = "with"
unban_player_ids_node = "unban_player_ids"

platform2unban = {
    "Desktop": ["desktop"],
    "Touch": ["touch", "tablet"],
    "All": ["desktop", "touch", "tablet"]
}


class UnbanCreator():
    class Player():
        def __init__(self, player_dict):
            self.host = player_dict[host_col]
            self.p_source = player_dict[source_col]
            self.p_type = player_dict[type_col]
            self.result = player_dict[result_col]
            self.platform = player_dict[platform_col] if platform_col in player_dict else "All"

    def __init__(self, ytc):
        self.ytc = ytc
        self.query = "* FROM [{0}] WHERE Result = True"
        self.unban_params = defaultdict(lambda: defaultdict(list))

    def get_player_id(self, player):
        return player.p_source + "_" + player.p_type + "__"

    def add_players(self, table, prefix):
        data = self.ytc.select_rows(self.query.format(table))
        self.add_unban(data, prefix)

    def add_unban(self, data, prefix):
        for line in data:
            player = self.Player(line)

            if self.check_player_status(player):
                unban_id = prefix + self.get_player_id(player)
                self.unban_params[unban_id][player.platform].append(player.host)

    def check_player_status(self, player):
        if player.p_source is None or player.p_type is None:
            assert player.p_source is None and player.p_type is None, "PlayerSource and PlayerType are not equivalent"
            return False

        return player.result

    def get_unban_config(self):
        config = defaultdict(list)

        for player_id in self.unban_params:
            player_params = self.unban_params[player_id]

            for platform in player_params:
                hosts = player_params[platform]
                platform_config = platform2unban[platform]

                result_config = {with_node: {host_node: hosts, platform_node: platform_config}}
                config[player_id].append(result_config)

        return {unban_player_ids_node: config}
