# -*- coding: utf-8 -*-_read_resource

import os
import logging

import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.copy as sdk_copy
import sandbox.sandboxsdk.paths as sdk_paths

from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types

from urlparse import urlparse

CONFIG_FILES = {
    "adv_partner_host.whitelist": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/adv_partner_host.whitelist",
    "areas.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/areas.lst",
    "bigrams.gz": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/bigrams.gz",
    "categ": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/categ",
    "categ.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/categ.cfg",
    "document_platforms.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/document_platforms.cfg",
    "document_platforms_dynamic.cfg": "VIDEO_DOCUMENT_PLATFORMS_CFG",
    "fltic_over30.txt": "VIDEO_TIC_OVER30",
    "geoa.c2p": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/geoa.c2p",
    "gruesome": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/gruesome",
    "gruesome.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/gruesome.cfg",
    "html5_host.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/html5_host.cfg",
    "i2t.dict": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/i2t.dict",
    "lang2region.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/lang2region.txt",
    "lemmas_merger_index": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/lemmas_merger_index",
    "mask_export.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/mask_export.trie",
    "owner_export.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/owner_export.trie",
    "connectors_urlbase.xml": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/player/connectors_urlbase.xml",
    "connectors_raw.xml": "VIDEO_CONFIG_AUTOPLAYER",
    "player_unban.json": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/player/unban.json",
    "porno": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/porno",
    "porno.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/porno.cfg",
    "porno_host.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/porno_host.cfg",
    "pure": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/pure",
    "quality": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/quality",
    "quality.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/quality.cfg",
    "relev_regions.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/relev_regions.txt",
    "semantic.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/semantic.cfg",
    "stopwords.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/stopwords.txt",
    "w2v.model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/w2v.model.bin",
    "english_video_title_keywords.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/english_video_title_keywords.txt",
}


class VideoBuildVegasConfig(sdk_task.SandboxTask):
    type = 'VIDEO_BUILD_VEGAS_CONFIG'

    def on_execute(self):
        logging.info('Get resource object')
        resource_id = self.create_resource(
            "video Vegas config", 'config',
            resource_types.VIDEO_CONFIG_VEGAS,
        ).id
        resource = channel.sandbox.get_resource(resource_id)
        self.dst_folder = resource.path
        sdk_paths.make_folder(self.dst_folder, True)

        self._fill_resource()

        channel.task.mark_resource_ready(resource)

    def on_release(self, additional_parameters):
        sdk_task.SandboxTask.on_release(self, additional_parameters)

    def _fill_resource(self):
        sdk_paths.make_folder(self.dst_folder, True)
        for filename, src_path in CONFIG_FILES.iteritems():
            self._get_file(filename, src_path)

    def _get_file(self, filename, src_path):
        dst_path = os.path.join(self.dst_folder, filename)
        parsed_url = urlparse(src_path)
        if parsed_url.scheme:
            self._download_file(src_path, dst_path)
        else:
            self._get_from_resource(src_path, dst_path)

    def _download_file(self, src, dst):
        sdk_copy.RemoteCopy(src, dst,
                                   log_dir=self.log_path())(timeout=sdk_copy.RemoteCopy.DEFAULT_TIMEOUT)

    def _get_from_resource(self, src, dst):
        resource_id = channel.sandbox.list_releases(
            resource_type=src, limit=1)[0].resources[0].id
        resource_path = self.sync_resource(resource_id)
        sdk_paths.copy_path(resource_path, dst)


__Task__ = VideoBuildVegasConfig
