# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.search import idx_ops
from sandbox.projects.common.search.settings import VideoSettings


_PARAMS = idx_ops.create_input_parameters(
    resource_types.IDX_OPS_VIDEO_EXECUTABLE,
    resource_types.VIDEO_SEARCH_DATABASE,
    database_required=False
)


class VideoGetIdxOpsResponses(idx_ops.BaseGetIdxOpsResponses):
    """
        Запускает утилиту idx_ops_video на указанных
        базе данных и запросах,
        вывод утилиты сохраняется для дальнейшего анализа
    """

    type = 'VIDEO_GET_IDX_OPS_RESPONSES'

    input_parameters = _PARAMS.params + idx_ops.BaseGetIdxOpsResponses.input_parameters

    def on_execute(self):
        VideoSettings.ensure_search_database(
            self.ctx, idx_ops.QueriesParameter, _PARAMS.SearchDatabaseParameter)
        idx_ops.BaseGetIdxOpsResponses.on_execute(self)


__Task__ = VideoGetIdxOpsResponses
