# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.sandboxsdk.parameters import LastReleasedResource

from sandbox.projects.common.middlesearch.evlogcachehit import TestMiddlesearchEvlogCachehit
from sandbox.projects.common.search import components as search_components
from sandbox.projects.common.search import settings as search_settings


class PlanParameter(LastReleasedResource):
    name = 'middlesearch_cachehit_plans_resource_id'
    description = 'Plan'
    resource_type = resource_types.VIDEO_MIDDLESEARCH_PLAN


class VideoGetMiddlesearchTenvCachehit(TestMiddlesearchEvlogCachehit):
    """
        Измеряет кэшхит метапоиска
        http://wiki.yandex-team.ru/JandeksPoisk/KachestvoPoiska/Middlesearch/Cachehit
    """

    type = 'VIDEO_GET_MIDDLESEARCH_TENV_CACHEHIT'

    execution_space = 40 * 1024
    input_parameters = TestMiddlesearchEvlogCachehit.input_parameters + (PlanParameter,)

    def _get_plan_path(self):
        return self.sync_resource(self.ctx[PlanParameter.name])

    def _get_plan_name(self):
        return self.descr

    # TODO: remove after fix in web tasks
    def _process_evlogcachehit_output(self, stats, search_source_names):
        pass

    def on_enqueue(self):
        TestMiddlesearchEvlogCachehit.on_enqueue(self)
        search_settings.VideoSettings.ensure_middlesearch_index(
            self,
            PlanParameter,
            search_components.DefaultMiddlesearchParams.Index
        )

    def on_execute(self):
        search_settings.VideoSettings.ensure_middlesearch_index(
            self,
            PlanParameter,
            search_components.DefaultMiddlesearchParams.Index
        )
        TestMiddlesearchEvlogCachehit.on_execute(self)


__Task__ = VideoGetMiddlesearchTenvCachehit
