import logging

from sandbox.projects import resource_types

from sandbox.projects.common.search import database as search_database


class VideoLoadBasesearchDatabase(search_database.BaseLoadDatabaseTask):
    """
        Download database for Yandex.Video service
    """

    type = 'VIDEO_LOAD_BASESEARCH_DATABASE'

    input_parameters = search_database.BaseLoadDatabaseTask.input_parameters

    def on_execute(self):
        logging.debug('VideoLoadBasesearchDatabase.on_execute()...')
        search_database.BaseLoadDatabaseTask.on_execute(self)

    def _get_expected_files(self):
        return []

    def _get_database_resource_type(self):
        return resource_types.VIDEO_SEARCH_DATABASE


__Task__ = VideoLoadBasesearchDatabase
