# coding: utf-8

import datetime
from sandbox.sandboxsdk.parameters import SandboxIntegerParameter
import sandbox.projects.MediaLib.VideoMetricsStability as vms


class StabilityWindow(SandboxIntegerParameter):
    name = 'window'
    description = 'Window (days)'
    default_value = vms._DAYS


class VideoMetricsStability(vms.VideoMetricsStability):
    """
        Метрика стабильности
    """

    cores = 1
    execution_space = 1024  # 1 Gb
    type = 'VIDEO_METRICS_STABILITY'

    input_parameters = [
        vms.ReleasableResourceType,
        vms.ReportName,
        vms.ReportScale,
        vms.TargetReleasesNumPerDay,
        StabilityWindow,
        vms.LimitListResources
    ]

    def on_execute(self):
        resource_name = self.ctx[vms.ReleasableResourceType.name]
        limit_rs = self.ctx[vms.LimitListResources.name]
        period_end = datetime.datetime.now()
        period_start = period_end - datetime.timedelta(days=self.ctx[StabilityWindow.name])
        target_num = self.get_target_releases_num(self.ctx[vms.TargetReleasesNumPerDay.name], period_start, period_end)
        all_releases = self.get_releases_list(resource_name, limit_rs)
        all_times = self.get_release_times(all_releases)
        releases = self.get_releases_for_period(
            all_times,
            period_start,
            period_end)
        stability = 0.00
        report_date = self._scale_date(period_end, self.ctx[vms.ReportScale.name])
        if releases:
            stability = self.get_stability(len(releases), target_num)
        self.set_info('Releases number for the last {} days: {}'.format(self.ctx[StabilityWindow.name], len(releases)), do_escape=False)
        self.set_info('Stability metric is: {0:.2f}%'.format(stability))
        data = {}
        data['fielddate'] = report_date
        data['stability'] = stability
        self.statface_upload(
            self.ctx[vms.ReportName.name],
            self.ctx[vms.ReportScale.name],
            [data]
        )


__Task__ = VideoMetricsStability
