# coding: utf-8

import datetime
import json

from sandbox.sandboxsdk.parameters import SandboxIntegerParameter

import sandbox.projects.MediaLib.VideoMetricsStability as vms

# class StabilityPeriod(SandboxIntegerParameter):
#    name = 'period_size'
#    description = 'Period (days)'
#    default_value = vms._DAYS


class StabilityWindow(SandboxIntegerParameter):
    name = 'window'
    description = 'Window (days)'
    default_value = vms._DAYS


class VideoMetricsStabilityHistory(vms.VideoMetricsStability):
    """
        История стабильности
    """

    type = 'VIDEO_METRICS_STABILITY_HISTORY'

    input_parameters = vms.VideoMetricsStability.input_parameters + [StabilityWindow]

    def on_execute(self):
        resource_name = self.ctx[vms.ReleasableResourceType.name]
        limit_rs = self.ctx[vms.LimitListResources.name]
        start = self._parse_date(self.ctx[vms.StartDate.name])
        end = self._parse_date(self.ctx[vms.EndDate.name])
        window = self.ctx[StabilityWindow.name]
        target_num = self.get_target_releases_num(
            self.ctx[vms.TargetReleasesNumPerDay.name],
            datetime.datetime.now() - datetime.timedelta(days=window),
            datetime.datetime.now()
        )
        report = {}
        report['values'] = []
        all_releases = self.get_releases_list(resource_name, limit_rs)
        all_times = self.get_release_times(all_releases)
        period_start = end - datetime.timedelta(days=window)
        while period_start >= start:
            period_end = period_start + datetime.timedelta(days=window)
            releases = self.get_releases_for_period(
                all_times,
                period_start,
                period_end
            )
            stability = 0.00
            report_date = self._scale_date(period_end, self.ctx[vms.ReportScale.name])
            if releases:
                stability = self.get_stability(len(releases), target_num)
            data = {}
            data['fielddate'] = report_date
            data['stability'] = stability
            report['values'].append(data)
            period_start = period_start - datetime.timedelta(hours=1)
        self.set_info(json.dumps(report))


__Task__ = VideoMetricsStabilityHistory
