# coding: utf-8

import datetime
from sandbox.sandboxsdk.parameters import SandboxIntegerParameter
import sandbox.projects.MediaLib.VideoMetricsStability as vms


class TimeDelta(SandboxIntegerParameter):
    name = 'time_delta_min'
    description = 'Stat for last N minutes'
    required = True


class VideoMetricsSwitchTime(vms.VideoMetricsStability):
    """
        Метрика времени переключения
    """

    type = 'VIDEO_METRICS_SWITCH_TIME'

    cores = 1
    execution_space = 1024  # 1 Gb

    input_parameters = [
        vms.ReleasableResourceType,
        vms.ReportName,
        vms.ReportScale,
        TimeDelta,
        vms.LimitListResources
    ]

    def on_execute(self):
        resource_name = self.ctx[vms.ReleasableResourceType.name]
        limit_rs = self.ctx[vms.LimitListResources.name]
        period_end = datetime.datetime.now()
        period_start = period_end - datetime.timedelta(minutes=self.ctx[TimeDelta.name])
        report = []
        all_releases = self.get_releases_list(resource_name, limit_rs)
        all_times = self.get_release_times(all_releases)
        releases = self.get_releases_for_period(
            all_times,
            period_start,
            period_end)
        for r in releases:
            report_date = self._scale_date(
                datetime.datetime.fromtimestamp(r.timestamp),
                self.ctx[vms.ReportScale.name])
            data = {}
            data['fielddate'] = report_date
            data['switch_time'] = float(r.switch_time)/60.
            report.append(data)
        if report:
            self.statface_upload(
                self.ctx[vms.ReportName.name],
                self.ctx[vms.ReportScale.name],
                report
            )


__Task__ = VideoMetricsSwitchTime
