# coding: utf-8

import datetime
import json

import sandbox.projects.MediaLib.VideoMetricsStability as vms


class VideoMetricsSwitchTimeHistory(vms.VideoMetricsStability):
    """
        История времени переключения
    """

    type = 'VIDEO_METRICS_SWITCH_TIME_HISTORY'

    input_parameters = [
        vms.ReleasableResourceType,
        vms.ReportScale,
        vms.StartDate,
        vms.EndDate,
        vms.LimitListResources
    ]

    def on_execute(self):
        resource_name = self.ctx[vms.ReleasableResourceType.name]
        limit_rs = self.ctx[vms.LimitListResources.name]
        period_end = self._parse_date(self.ctx[vms.EndDate.name])
        period_start = self._parse_date(self.ctx[vms.StartDate.name])
        report = {}
        report['values'] = []
        all_releases = self.get_releases_list(resource_name, limit_rs)
        all_times = self.get_release_times(all_releases)
        releases = self.get_releases_for_period(
            all_times,
            period_start,
            period_end)
        for r in releases:
            report_date = self._scale_date(
                datetime.datetime.fromtimestamp(r.timestamp),
                self.ctx[vms.ReportScale.name])
            data = {}
            data['fielddate'] = report_date
            data['switch_time'] = float(r.switch_time)/60.
            report['values'].append(data)
            self.set_info('{} {} {}'.format(str(r.release_obj), report_date, float(r.switch_time)/60.))
        self.set_info(json.dumps(report))
        # self.set_info("Releases:")
        # self.set_info('\n'.join(map(lambda r: str(r.release_obj), releases)))


__Task__ = VideoMetricsSwitchTimeHistory
