# coding: utf-8
import json
import sandbox.projects.MediaLib.VideoMetricsStability as vms
from sandbox.sandboxsdk.parameters import SandboxStringParameter


class DataJson(SandboxStringParameter):
    name = 'data'
    description = 'Data to upload'
    required = True


class VideoMetricsUploadStat(vms.VideoMetricsStability):
    """
        Загрузка json данных в стат
    """

    type = 'VIDEO_METRICS_UPLOAD_STAT'

    cores = 1
    execution_space = 1024  # 1 Gb

    input_parameters = [
        vms.ReportName,
        vms.ReportScale,
        DataJson
    ]

    def on_execute(self):
        self.statface_upload(
            self.ctx[vms.ReportName.name],
            self.ctx[vms.ReportScale.name],
            json.loads(self.ctx[DataJson.name])
        )


__Task__ = VideoMetricsUploadStat
