from sandbox.sandboxsdk.errors import SandboxTaskFailureError

from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common import dolbilka
from sandbox.projects.common.mediasearch.acceptance import database

from sandbox.projects import VideoAnalyzeBasesearchPerformance as analyze_task
from sandbox.projects import VideoLoadBasesearchDatabase as load_task


_SHARD_MAPS = 'shard_maps'


class VideoProductionResourcesTask:
    """Mixin class to calculate resources from production"""

    def _get_basesearch_snippetizer_index_type(self, index_type=media_settings.INDEX_MAIN):
        return index_type  # Video has no separate snippetizers


class VideoPriemkaBasesearchDatabase2(VideoProductionResourcesTask,
                                      database.BasePriemkaDatabaseTask):
    """
        [SKETCH] Video search database acceptance task
    """

    type = 'VIDEO_PRIEMKA_BASESEARCH_DATABASE2'

    ###
    def _get_tests(self):
        return (
            (media_settings.INDEX_MAIN, "search", None),
            (media_settings.INDEX_MAIN, "search", 0.5),
        )

    def _get_index_type_for_tier(self, tier):
        return media_settings.VideoSettings.index_type_for_tier(tier)

    def _get_shard_name(self, age, index_type):
        if index_type in (media_settings.INDEX_MIDDLE):
            return []
        if index_type not in (media_settings.INDEX_MAIN):
            raise SandboxTaskFailureError("Unsupported index type {}".format(index_type))
        return self.ctx[_SHARD_MAPS][age][index_type]

    ###
    def _get_database_task(self, index_type):
        return load_task.VideoLoadBasesearchDatabase.type

    def _get_database_args(self, index_type):
        return {
            'index_type': index_type,
        }

    def _get_database_resource(self, index_type):
        return media_settings.VideoSettings.basesearch_database_resource(index_type)

    ###
    def _get_basesearch_executable(self, index_type):
        return (self.ctx.get("basesearch_{}_executable_resource_id".format(index_type)) or
                VideoProductionResourcesTask._get_basesearch_executable(self, index_type))

    def _get_basesearch_config(self, index_type):
        return (self.ctx.get("basesearch_{}_config_resource_id".format(index_type)) or
                VideoProductionResourcesTask._get_basesearch_config(self, index_type))

    def _get_basesearch_performance_task(self, index_type):
        task_type = analyze_task.VideoAnalyzeBasesearchPerformance.type
        basesearch_params = (
            analyze_task.BASESEARCH1_PARAMS,
            analyze_task.BASESEARCH2_PARAMS,
        )
        plan_params = (
            analyze_task.Plan1Parameter,
            analyze_task.Plan2Parameter,
        )
        return task_type, basesearch_params, plan_params

    def _get_basesearch_performance_args(self, index_type, query_type):
        sub_ctx = {
            dolbilka.DolbilkaExecutorMode.name: 'finger',
            dolbilka.DolbilkaMaximumSimultaneousRequests.name: 20,
        }

        sub_ctx.update({
            dolbilka.DolbilkaExecutorRequestsLimit.name: 500000,
        })

        return sub_ctx


__Task__ = VideoPriemkaBasesearchDatabase2
