import logging

from sandbox.projects.common.mediasearch import release as media_release

from sandbox.projects import VideoBuildAndTestDynamicModels as task


class VideoReleaseBasesearchModels(media_release.BaseNannyTask, media_release.BaseReleaseTask):
    """
        Build, test and release archive with dynamic models for basesearch
    """

    type = 'VIDEO_RELEASE_BASESEARCH_MODELS'

    input_parameters = task.VideoBuildAndTestDynamicModels.input_parameters + media_release.BaseReleaseTask.input_parameters

    models_resource = task.VideoBuildAndTestDynamicModels.archive_type

    release_subject = "video/base/models-{timestamp}"
    release_comment = "daily video basesearch models"
    release_resources = (models_resource,)
    release_mailto = "video-monitoring@yandex-team.ru"

    def _skip_build(self):
        return False

    def _do_build(self):
        # sub_ctx = {
        #     BuildDynamicModels.ModelsForProduction.name: self.ctx[BuildDynamicModels.ModelsForProduction.name],
        #     VideoBuildDynamicModels.ModelsUrlForProduction.name: self.ctx[VideoBuildDynamicModels.ModelsUrlForProduction.name],
        #     BuildDynamicModels.ModelsForExperiment.name: self.ctx[BuildDynamicModels.ModelsForExperiment.name],
        #     VideoBuildDynamicModels.ModelsUrlForExperiment.name: self.ctx[VideoBuildDynamicModels.ModelsUrlForExperiment.name],
        #     VideoBuildDynamicModels.CheckProductionModelsList.name: self.ctx[VideoBuildDynamicModels.CheckProductionModelsList.name],
        #     VideoBuildDynamicModels.StrictFormulaIdChecks.name: self.ctx[VideoBuildDynamicModels.StrictFormulaIdChecks.name],
        # }
        sub_task = self.create_subtask(
            task_type=task.VideoBuildAndTestDynamicModels.type,
            input_parameters=self.ctx,
            description=self.descr,
        )
        return sub_task.id

    def _do_test(self, build_task_id):
        return []

    def _do_monitor(self):
        pass

    def _can_release(self, build_task):
        diff = build_task.ctx['diff']
        changed = diff.get('changed', []) + diff.get('added', []) + diff.get('deleted', [])
        changed = [model for model in changed if model != 'meta']
        logging.info('MODELS ARE CHANGED' if changed else 'MODELS ARE THE SAME')

        return changed and media_release.BaseReleaseTask._can_release(self, build_task)


__Task__ = VideoReleaseBasesearchModels
